// Spline Wrap.js
//
// v.20110513: first version.
// v.20110513b: adding new paramters.
//
// this is a polygon script. place this into ~/Library/Application Support/Cheetah3D/scripts/Polygonobj folder.
// same as other creator object, this requires 2 child objects.
// 1st child must be spline object for profile, 2nd child requires polygon object for transform.
// polygon object ( 2nd child ) has to be aligned Y-axis.
// if you have twist problem as a result, try to change rotation of spline object ( 1st child ).
// 
// paramters
// [copy start] percentage of spline length for copy start.
// [copy scale] percentage of spline length for copy scale.
// [asy threshold] threshold to calculate an asymptote.

var Vec3D_len = function() {
    if( arguments.length == 1)
        return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
        var l = arguments[0].norm();
        if( l != 0) 
            return arguments[0].multiply(1/l);
        return arguments[0];
}

var splHolder = new Array;
var splList = new Array;

// static value, pre-calculated;
var radian_p = 180/Math.PI;

function buildUI(obj){
	obj.setParameter("name","Spline Wrap");
	
    obj.addParameterSelector("align by", ["x", "y", "z"], true, true);
    
    obj.addParameterSelector("spline rot", ["none", "x", "z"], true, true);
    
    obj.addParameterFloat("copy start", 0, -10000, 10000, true, true);
	obj.addParameterFloat("copy scale", 1, 0, 10000, true, true);
    
    obj.addParameterFloat("asy threshold", 0.01, 0.00001, 0.1, true, true);
    
    // debug
    //obj.addParameterFloat("theta", 0, -180, 180, true, true);
    //obj.addParameterFloat("phi", 0, -180, 180, true, true);
   
	obj.addParameterSeparator("Smooth");
	obj.addParameterSelector("smooth",["normalFlat","normalPhong","normalContraint"],true,true);
	obj.addParameterFloat("smooth angle",45,1,180,true,true);
	
	obj.setCreatorObj(true);
    obj.setParameter("align by", 1);
}

function buildObject(obj) {
	print('----');
	var n = obj.childCount();

    if (n < 2) return;
    
    var align = obj.getParameter("align by");
    var spline_rot = obj.getParameter("spline rot");
    
	var spline = obj.childAtIndex(0); // getting profile
	var poly = obj.childAtIndex(1); // getting poly
	if (spline.family() != SPLINEFAMILY || poly.family() != NGONFAMILY) return;
	
	var sCore = spline.modCore();
	var pCore = poly.modCore();

    switch( spline_rot ) {
        case 0:
            var matSpline = spline.objMatrix();
            var matBack = new Mat4D();
            break;
        case 1:
            var matSpline = (new Mat4D( ROTATE_HPB, 0, 0, -90)).multiply( spline.objMatrix() );
            var matBack = new Mat4D( ROTATE_HPB, 0, 0, 90);
            break;
        case 2:
            var matSpline = (new Mat4D( ROTATE_HPB, 0, 90,  0)).multiply( spline.objMatrix() );
            var matBack = new Mat4D( ROTATE_HPB, 0, -90, 0);
            break;
    }
    
    switch( align) {
        case 0:
            var matPoly = (new Mat4D( ROTATE_HPB, 0, 0, -90 )).multiply( poly.objMatrix() );
            break;
        case 1:
            var matPoly = poly.objMatrix();
            break;
        case 2:
            var matPoly = (new Mat4D( ROTATE_HPB, 0, -90, 0 )).multiply( poly.objMatrix() );
            break;
    }
	
	var pathCount = sCore.pathCount();
	var i,j;
	
	if (pathCount < 1) return;
	
	obj.setParameter("normalType",obj.getParameter("smooth"),false);
	obj.setParameter("normalAngle",obj.getParameter("smooth angle"),false);
	
    var threshold = obj.getParameter("asy threshold");
    var scale = obj.getParameter("copy scale");
    var start = obj.getParameter("copy start");
    // cache polygon info
    var vertexCount = pCore.vertexCount();
    var vec = matPoly.multiply(pCore.vertex(0));
    // calculate size: align z-axis
    var vMax = vec.y;
    var vMin = vec.y;
    for (i = 1;i < vertexCount;i++) {
        vec = matPoly.multiply(pCore.vertex(i));
        vMax = (vMax > vec.y)? vMax : vec.y;
        vMin = (vMin < vec.y)? vMin : vec.y;
    }
    var vLen = vMax - vMin;
    //print( '----' );
    //print( 'max:'+vMax.toFixed(2)+', min:'+vMin.toFixed(2)+', len:'+vLen.toFixed(2) );
    // cache spline
    spl = sCore.cache(0);
    if (spl != null) {
        splHolder = spl;
        cacheSplineLength();
    } else {
        return;
    }
    //
    var core = obj.core();
    for (i = 0;i < vertexCount;i++) {
        vec = matPoly.multiply(pCore.vertex(i));
        var percentage = (vec.y - vMin) / vLen * scale;
        
        var p = pointFromPercentage(start + percentage, matSpline );
        var asy = asyVecFromPercentage(start + percentage, matSpline, threshold);
        
        //print( '- ' + (start + percentage).toFixed(6) );
        //print( asy.x.toFixed(2) + ', '+asy.y.toFixed(2)+', '+asy.z.toFixed(2) );
        var theta = Math.acos( asy.y)*radian_p;
        var phi = Math.atan2( asy.x, asy.z)*radian_p;
        
        //theta = Math.abs( theta );
        
        var asyMat = new Mat4D( ROTATE_HPB, phi, theta, 0 );
        
        //print( theta.toFixed(2) + ', ' + phi.toFixed(2) );
        vec.y = 0;
        
        core.addVertex( false, matBack.multiply( p.add( asyMat.multiply( vec )) ) );
    }
    // create mesh
    var polygonCount = pCore.polygonCount();
    for (i = 0;i < polygonCount;i++) {
        var size = pCore.polygonSize(i);
        var verts = [];
        var uvs = [];
        for (j = 0;j < size;j++) {
            verts.push( pCore.vertexIndex(i, j) );
            uvs.push( pCore.uvCoord(i, j) );
        }
        var pi = core.addIndexPolygon( verts.length, verts );
        for (j = 0;j < size;j++) {
            core.setUVCoord( pi, j, uvs[j] );
        }
        for (j = 0;j < 16;j++) {
            core.setActivePolygonSelection(j);
            pCore.setActivePolygonSelection(j);
            core.setPolygonSelection( pi, pCore.polygonSelection( pi ) );
        }
    }
    pCore.setActivePolygonSelection(0);
    core.setActivePolygonSelection(0);
}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function asyVecFromPercentage(percent, mat, m) {
    if (1-m > percent) {
        var prePer = percent - m;
        var posPer = percent;
    } else if (m > percent) {
        var prePer = 0;
        var posPer = percent + m;
    } else {
        var prePer = percent - m;
        var posPer = percent + m;
    }
    
    prePos = pointFromPercentage( prePer, mat );
    posPos = pointFromPercentage( posPer, mat );
    
    var asyVec = posPos.sub(prePos);
    var norm = asyVec.norm();
    
    return (norm == 0)? asyVec.multiply(0) : asyVec.multiply( 1/asyVec.norm() ) ;
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}

